clear all

* Set Folder to input one

cd ..\Inputs

* Import and clean short term SPF data

import excel "SPF_Mean_RGDP_Level.xls", ///
sheet(Mean_Level) cellrange(A1) firstrow clear
destring RGDP6 RGDPA RGDPB RGDPC RGDPD, replace force

forvalues r=1/5 {
	gen GRGDP`r'=(ln(RGDP`=`r'+1')-ln(RGDP`r'))*400
}

* Rename variables that are annual

rename RGDPA ARGDP1
rename RGDPB ARGDP2
rename RGDPC ARGDP3
rename RGDPD ARGDP4

* Generate growth rates

forvalues r=1/3 {
	gen GARGDP`r'=(ln(ARGDP`=`r'+1')-ln(ARGDP`r'))*100
}

* Drop level variables

drop RGDP* ARGDP*

* Label variables

label var GRGDP1  "Quarterly Growth of Yearly Actual Real GDP 1 Quarter  Ahead"
label var GRGDP2  "Quarterly Growth of Yearly Actual Real GDP 2 Quarters Ahead"
label var GRGDP3  "Quarterly Growth of Yearly Actual Real GDP 3 Quarters Ahead"
label var GRGDP4  "Quarterly Growth of Yearly Actual Real GDP 4 Quarters Ahead"
label var GRGDP5  "Quarterly Growth of Yearly Actual Real GDP 5 Quarters Ahead"
label var GARGDP1 "Annual Growth of Yearly Actual Real GDP 1 Year  Ahead"
label var GARGDP2 "Annual Growth of Yearly Actual Real GDP 2 Years Ahead"
label var GARGDP3 "Annual Growth of Yearly Actual Real GDP 3 Years Ahead"

* Save short term SPF forecasts

save SPFSHORT, replace

* Import and clean long term SPF data

import excel "SPF_Mean_RGDP10_Level.xls", ///
sheet(Mean_Level) cellrange(A1) firstrow clear
destring RGDP10, replace force

rename RGDP10 GARGDP10
label var GARGDP10 "Annual Growth of Yearly Actual Real GDP 10 Years Ahead"

* Save long term SPF forecasts

save SPFLONG, replace

* Merge the two previous datasets
	
use SPFSHORT, clear
merge 1:1 YEAR QUARTER using SPFLONG
drop _merge

* Set time series to be able to use lag and difference operators

egen t=group(YEAR QUARTER)
tsset t

* Generate revisions

forvalues r=1/4 {
	gen revRact`=`r'-1'=GRGDP`r'-L.GRGDP`=`r'+1'
}

forvalues r=1/3 {
	gen rev2Ract`=`r'-1'=L.GRGDP`=`r'+1'-L2.GRGDP`=`r'+2'
}

forvalues r=1/2 {
	gen revRactA`r'=GARGDP`r'-L.GARGDP`=`r'+1'
}

egen sum1Ract3=rowmean(revRact0  revRact1  revRact2)
egen sum2Ract3=rowmean(rev2Ract0 rev2Ract1 rev2Ract2)
gen revRactA10=GARGDP10-L4.GARGDP10

forvalues r=1/5 {
	rename GRGDP`r' gRact`=`r'-1'
}

foreach r in 1 2 3 10 {
	rename GARGDP`r' gRactA`r'
}

rename YEAR year
rename QUARTER quarter
drop t

* Rename variables

ds year quarter, not
foreach var of varlist `r(varlist)' {
	rename `var' SPF`var'
}

* Change to output folder and save

cd ..\Outputs
save Data_SPF, replace

* Change back to input folder and delete temporary databases

cd ..\Inputs

erase SPFSHORT.dta
erase SPFLONG.dta
